	clear all
	close all
	clc
	% Lattice Wave Digital Filter 12.26
	fs = 16; lw = 2; fn = 'times'; 
	WcT = 0.55*pi; WsT = 0.6*pi; Amax = 0.1; Amin = 65;
	N = CA_ORDER_Z(WcT, WsT, Amax, Amin);
	N = 9;	% We MUST select an odd order
	[G, Z, R_ZEROS, P, WsnewT] = CA_POLES_Z(WcT, WsT, Amax, Amin, N);	
	%	figure(1)
	%	PLOT_PZ_Z(Z, P)
	wT = linspace(0, pi, 1000); S = zeros(1,1000);
	[Godd, Podd, Geven, Peven] = SORT_LATTICE_POLES_LP_Z(P);
	[alfa_odd, alfa_even] = CASCADE_RICHARDS_SECTIONS(Podd, Peven);
	%	c0 = 1/2;	c1 = 1/16;c2=1;	c3 = 2/4;c4=1/2;	c5 = 1/2;c6=1/2; 	c7 = 1/4;c8=1/2;
	c0=1/2;c1=1/8;c2=1/2;c3=1/4;c4=1;c5=1/2;c6=1;c7=1/4;c8=1/2;
	% Cost = 14 Wd = 10
	alfa0 = [340/1024 -980/1024 -176/1024  -650/1024 10/1024 -320/1024 320/1024 -864/1024 -128]/1024;
	alfa0 = [85/256 -245/256  -11/64 -325/512  5/512 -5/16 5/16 -27/32 -1/8];
			v1 = 0;v21=0;v22=0;v31=0;v32=0;v41=0;v42=0;v51 =0; v52 =0;
	x=1; 
	for n = 1:22			
			T1 = c0*x; X(10,1) = (1-c0^2);
			a = (v1-T1);
			%		f0 = f0+a^2;
			T2 = alfa_odd(1)*a; 
			b1 = (v1+T2)/c0;
			v1 = T1+T2;
			%
			T21 = c1*b1; X(11,1) = (1-c1^2);
			T22 = c2*v21; X(12,1) = (1-c2^2);
			a = (v22-T22);
			%		f1 = f1+a^2;
			T23 = alfa_odd(3)*a ; 
			T24 = (v22+T23)/c2;
			v22 = T22+T23;
			a = (T24-T21);
			%		f2 = f2+a^2;
			T25 = alfa_odd(2)*a;
			v21 = T21+T25;
			b2 = (T24+T25)/c1;
			
			T31 = c3*b2; X(13,1) = (1-c3^2);
			T32 = c4*v31;
			a = (v32-T32);
			%		f3 = f3+a^2;
			T33 = alfa_odd(5)*a;
			T34 = (v32+T33)/c4;
			v32 = T32+T33;
			a = (T34-T31);
			%		f4 = f4+a^2;
			T35 = alfa_odd(4)*a;
			v31 = T31+T35;
			b3 = (T34+T35)/c3;		
			%=========================
			
			T41 = c5*x; X(14,1) = (1-c5^2);
			T42 = c6*v41;
			a = (v42-T42);
			%		f5 = f5+a^2;
			T43 = alfa_even(2)*a;
			T44 = (v42+T43)/c6;
			v42 = T42+T43;
			a = (T44-T41);
			%		f6 = f6+a^2;
			T45 = alfa_even(1)*a;
			v41 = T41+T45;
			b4 = (T44+T45)/c5;
			%==
			T51 = c7*b4; X(15,1) = (1-c7^2);
			T52 = c8*v51; X(16,1) = (1-c8^2);
			a = (v52-T52);	
			%		f7 = f7+a^2;
			T53 = alfa_even(4)*a ;
			T54 = (v52+T53)/c8;
			v52 = T52+T53;
			a = (T54-T51);	
			%		f8 = f8+a^2;
			T55 = alfa_even(3)*a;
			v51 = T51+T55;
			b5 = (T54+T55)/c7;
			%=====
			h(n) =  (b5+b3)/2;
			%		f9 = f9+h(n)^2; 
			x = 0;
		end
		[G, Z, P] = IMPULSE_2_P_Z(h, 9);
		Att = PZ_2_ATT_Z(G, Z, P, wT);
		A = Att-min(Att);
		Taug = PZ_2_TG_Z(G, Z, P, wT);
		figure(1)
		PLOT_ATT_Z(wT, Att, pi, 80)	, hold on
 
		Nnodes=17;
		e = zeros(Nnodes,1); G = zeros(Nnodes,1);  X = ones(Nnodes,1);
		for m = 1:Nnodes
			v1 = 0;v21=0;v22=0;v31=0;v32=0;v41=0;v42=0;v51 =0; v52 =0;
			f0 = 0; f1 = 0; f2 = 0; f3=0; f4=0; f5=0; f6=0; f7=0; f8=0; f9=0;	
			x = 0;
			e(m,1) = 1; sig = 0; 
			for n = 1:22
				if m == 17
						x = e(17,1);
				end
				T1 = c0*x + e(10,1); X(10,1) = (1-c0^2);
				a = (v1-T1);
				%		f0 = f0+a^2;
				T2 = alfa_odd(1)*a + e(1,1); 
				b1 = (v1+T2)/c0;
				v1 = T1+T2;
				%
				T21 = c1*b1 +  e(11,1); X(11,1) = (1-c1^2);
				T22 = c2*v21 +  e(12,1); X(12,1) = (1-c2^2);
				a = (v22-T22);
				%		f1 = f1+a^2;
				T23 = alfa_odd(3)*a + e(3,1); 
				T24 = (v22+T23)/c2;
				v22 = T22+T23;
				a = (T24-T21);
				%		f2 = f2+a^2;
				T25 = alfa_odd(2)*a+ e(2,1);
				v21 = T21+T25;
				b2 = (T24+T25)/c1;
				
				T31 = c3*b2 +  e(13,1); X(13,1) = (1-c3^2);
				T32 = c4*v31;
				a = (v32-T32);
				%		f3 = f3+a^2;
				T33 = alfa_odd(5)*a + e(5,1);;
				T34 = (v32+T33)/c4;
				v32 = T32+T33;
				a = (T34-T31);
				%		f4 = f4+a^2;
				T35 = alfa_odd(4)*a + e(4,1);
				v31 = T31+T35;
				b3 = (T34+T35)/c3;		
				%=========================
				
				T41 = c5*x +  e(14,1); X(14,1) = (1-c5^2);
				T42 = c6*v41;
				a = (v42-T42);
				%		f5 = f5+a^2;
				T43 = alfa_even(2)*a + e(7,1);
				T44 = (v42+T43)/c6;
				v42 = T42+T43;
				a = (T44-T41);
				%		f6 = f6+a^2;
				T45 = alfa_even(1)*a + e(6,1);
				v41 = T41+T45;
				b4 = (T44+T45)/c5;
				%==
				T51 = c7*b4 + e(15,1); X(15,1) = (1-c7^2);
				T52 = c8*v51 + e(16,1); X(16,1) = (1-c8^2);
				a = (v52-T52);	
				%		f7 = f7+a^2;
				T53 = alfa_even(4)*a + e(9,1);
				T54 = (v52+T53)/c8;
				v52 = T52+T53;
				a = (T54-T51);	
				%		f8 = f8+a^2;
				T55 = alfa_even(3)*a + e(8,1);
				v51 = T51+T55;
				b5 = (T54+T55)/c7;
				%=====
				h(n) =  (b5+b3)/2;
				%		f9 = f9+h(n)^2; 
				x = 0;
				e = zeros(Nnodes,1);
				%	G(m,1) = G(m,1) + X(m,1)*h(n)^2;
			end
			% if h(1) == 0, h(1) = []; end
			% if m == 17, h0=h;end
			[G, Z, P] = IMPULSE_2_P_Z(h, 9);	
			%	[b,c] = imp2tf(h);
			%	 Z=roots(b);P=roots(c);
			G=h(1);
			H = PZ_2_FREQ_Z(G, Z, P, wT);
			Att = PZ_2_ATT_Z(G, Z, P, wT); 	
			%		A = Att-min(Att);	
			
			Taug = PZ_2_TG_Z(G, Z, P, wT);
			
			S = S + X(m,1)*abs(H).^2;
		end
		figure(1)
		subplot('position', [0.09 0.4 0.88 0.5]);	 
		
		PLOT_ATT_S_Z(Att, S, wT, 80, 400),hold on
		hold on
			plot(wT, Taug,'linewidth',lw); 
	
			text(0.8, 90,'Group Delay','FontName',fn,'FontSize',fs);
	text(0.5, 150,'Noise spectral density','FontName',fn,'FontSize',fs);
	%text(0.94,18.3,'\uparrow','fontsize',20)
	text(1.2,45,'\downarrow','fontsize',25)
	text(1.5,145,'\rightarrow','fontsize',25)
	 
		%	G
		%	sum(G)
		if 1==2
			f0
			f1
			f2
			f3
			f4
			f5
			f6
			f7
			f8
			f9
			
			figure(2)
			PLOT_IMPULSE_RESPONSE_Z(h)
			
			wT = linspace(0, pi,1000);
			[T,D] = imp2tf(h);
			Z = roots(T);
			P = roots(D);
			% qfigure(3)
			%	[G, Z, P] = h_2_Hz(h, 9)
			%	PLOT_PZ_Z(Z, P)
			
			figure(4)
			subplot('position', [0.1 0.4 0.88 0.5]);
			G = 0.030883078252020871;
			Att = PZ_2_ATT_Z(G, Z, P, wT);
			PLOT_ATT_Z(wT, Att, pi, 80)	
			%axis([0 pi 0 80])
		end
